/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于编写'图标按钮编辑'功能的测试用例
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 巫昭雯
 *      时间 : 2021.5.18
 *      内容 : 所有代码
 *************************************************************************************************/

/* exported tc_ibtn_edit_switch_show*/
/* exported tc_ibtn_edit_open*/
/* exported tc_ibtn_edit_close*/
/* exported tc_ibtn_click_edit*/
/* exported tc_ibtn_random_edit*/
/* exported tc_ibtn_random_click*/
/* exported tc_ibtn_process_one*/

/* global $ */
/* global tc_tool_get_main_htmliframe */
/* global tc_tool_get_random_idx */
/* global tc_tool_close_all_layer */


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    切换显示; 打开或关闭布局;
 * 参数:
 *    @param { Promise<Boolean> } b true === 打开
 *    @param { Promise<Function> } callback
 * 返回:
 *    @returns { Promise<undefined> }
 * 例子:
 *    NA
 * 备注:
 *    1. 回调参数(code, msg)
 *    code :  参数(1 === 成功  || 0 === false)
 *    msg : 说明
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-18
 *       内容 : 所有代码
************************************************************************************************/
function tc_ibtn_edit_switch_show(b, callback) {
    var o_doc = tc_tool_get_main_htmliframe().contentDocument;
    var o_open_btn = o_doc.getElementById("mc_side_btn_open_all");
    var o_ibtn_layout = o_doc.getElementById("mc_container_edit_ibtn");

    if (!o_open_btn && !o_ibtn_layout) {
        return callback(0, "'打开按钮'或'编辑布局'不存在");
    }

    if (b && "block" !== o_ibtn_layout.style.display) {
        o_open_btn.click();
        return callback(1, "已打开编辑界面");
    }

    if (!b && "none" !== o_ibtn_layout.style.display) {
        o_open_btn.click();
        return callback(1, "已关闭编辑界面");
    }

    if (b) {
        return callback(0, "已处于'打开状态'");
    }

    return callback(0, "已处于'关闭状态'");
}


// 打开
function tc_ibtn_edit_open(callback) {
    tc_tool_close_all_layer();
    tc_ibtn_edit_switch_show(true, callback);
}

// 关闭
function tc_ibtn_edit_close(callback) {
    setTimeout(function () {
        tc_ibtn_edit_switch_show(false, callback);
    },1000);
}


// true (o_ibtn_layout) === "open"
function tc_iben_util_open_status() {
    var o_doc = tc_tool_get_main_htmliframe().contentDocument;
    var o_ibtn_layout = o_doc.getElementById("mc_container_edit_ibtn");

    if (o_ibtn_layout) {
        switch (o_ibtn_layout.style.display) {
        case "none":
            return false;
        case "block":
            return o_ibtn_layout;
        default:
            return o_ibtn_layout;
        }
    }

    return false;
}

/************************************************************************************************
 * 类型:
 *    函数; 测试用例执行函数
 * 功能:
 *    点击 "编辑"
 * 参数:
 *    @param { Promise<Function> } callback
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-18
 *       内容 : 所有代码
************************************************************************************************/
function tc_ibtn_click_edit(callback) {
    // MC_LANG_EDIT
    tc_ibtn_edit_switch_show(true, function () {
        setTimeout(function () {
            var o_doc = tc_tool_get_main_htmliframe().contentDocument;
            var o_ibtn_layout = o_doc.getElementById("mc_container_edit_ibtn");

            if (o_ibtn_layout) {
                var o_btn_edit = $(o_ibtn_layout).find("[lang_id='MC_LANG_EDIT']");

                if (o_btn_edit.length) {
                    o_btn_edit.click();
                    return callback(1, "点击编辑");
                }

                return callback(0, "'编辑按钮'不存在");
            }

            return callback(0, "'编辑布局'容器不存在");
        }, 1000);
    });
}


/************************************************************************************************
 * 类型:
 *    函数; 测试用例执行函数
 * 功能:
 *    随机编辑; 编辑状态下随机点击添加或删除
 * 参数:
 *    @param { Promise<Function> } callback
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-18
 *       内容 : 所有代码
************************************************************************************************/
function tc_ibtn_random_edit(callback) {
    // edit_icon_btn
    tc_ibtn_click_edit(function (code, msg) {
        if (0 === code) {
            callback(code, msg);
            return;
        }

        setTimeout(function () {
            var ui_count = tc_tool_get_random_idx(8) + 1;
            var s_msg = "<p>随机次数: " + ui_count + "</p>";
            var index = 0;

            while (index < ui_count ) {
                index++;
                var obj_rendom = tc_ibtn_get_random_ibtn();
                var str_msg = $(obj_rendom).hasClass("close") ? "删除" : "添加";

                obj_rendom.click();
                var res = "<p>" + str_msg + " '" + obj_rendom.title + "' " + "图标" + "</p>";

                s_msg += res;
            }

            callback(1, s_msg);
        }, 1000);
    });
}


/************************************************************************************************
 * 类型:
 *    函数; 测试用例执行函数
 * 功能:
 *    随机点击; 在未编辑状态下随机点击图标按钮
 * 参数:
 *    @param { Promise<Function> } callback
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-18
 *       内容 : 所有代码
************************************************************************************************/
function tc_ibtn_random_click(callback) {
    tc_ibtn_edit_switch_show(true, function () {
        tc_ibtn_click_done();
        tc_tool_close_all_layer();
        setTimeout(function () {
            var obj_rendom = tc_ibtn_get_random_ibtn();

            obj_rendom.click();

            callback(1, "点击" + " '" + obj_rendom.title + "' " + "图标");
        }, 1000);
    });
}


/************************************************************************************************
 * 类型:
 *    函数; 该文件内部处理函数
 * 功能:
 *    获取随机的按钮; 在该布局下的全部按钮;
 * 参数:
 *    NA
 * 返回:
 *    @returns { Promise<Object> } 按钮对象
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-18
 *       内容 : 所有代码
************************************************************************************************/
function tc_ibtn_get_random_ibtn() {
    var o_doc = tc_tool_get_main_htmliframe().contentDocument;
    var arr_ibtn_add = o_doc.getElementById("mc_container_edit_ibtn").querySelectorAll(".edit_icon_btn");
    var ui_len = arr_ibtn_add.length;
    var ui_random_i = tc_tool_get_random_idx(ui_len);
    var obj_rendom = arr_ibtn_add[ui_random_i];

    return obj_rendom;
}


// 点击'完成'
function tc_ibtn_click_done() {
    // var obj_btn = data-operation="edit"
    var o_doc = tc_tool_get_main_htmliframe().contentDocument;
    var o_btn = $(o_doc).find("[data-operation='edit']");

    if ("none" === window.getComputedStyle(o_btn[0]).display) {
        $(o_doc).find("[data-operation='done']").click();
    }
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    随机编辑之后点击完成;
 * 参数:
 *    @param { Promise<Function> } callback
 * 返回:
 *    NA
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 巫昭雯
 *       时间 : 2021-05-18
 *       内容 : 所有代码
************************************************************************************************/
function tc_ibtn_process_one(callback) {
    tc_tool_close_all_layer();
    tc_ibtn_random_edit(function (code, msg) {
        if (0 === code) {
            callback(code, msg);
            return;
        }

        setTimeout(function () {
            tc_ibtn_click_done();
            tc_ibtn_edit_switch_show(false, function () {
                callback(1, msg);
            });
        }, 1000);
    });
}


